﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Reports
{
    public partial class SalesReport : System.Web.UI.Page
    {
        protected DataTable sales;
        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindSalesReports(DateTime.MinValue, DateTime.MinValue);
            }
        }

        private void BindSalesReports(DateTime fromDate, DateTime toDate)
        {
            sales = ReportsBL.GetSalesReport(fromDate, toDate);
            grdCustomers.DataSource = sales;
            grdCustomers.DataBind();

            if (sales.Rows.Count == 0)
                WebUtilities.ShowMessage(this, "No Orders found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindSalesReports(DateTime.MinValue, DateTime.MinValue);
            Master.ExportToExcel<Entities.UserAccount>(grdCustomers, "SalesReport");
        }
        protected void grdCustomers_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdCustomers.PageIndex = e.NewPageIndex;
            BindSalesReports((string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                 (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)));
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtFromDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtFromDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid From Date");
                return;
            }

            if (txtToDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtToDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid To Date");
                return;
            }

            BindSalesReports((string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                 (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)));
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindSalesReports(DateTime.Now, DateTime.Now);
        }
    }
}